% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_pack.R
\name{bin_pack_ffd}
\alias{bin_pack_ffd}
\title{1D bin packing "First Fit (Decreasing)" algorithm}
\usage{
bin_pack_ffd(x, cap, sort = TRUE)
}
\arguments{
\item{x}{[\code{\link[=numeric]{numeric()}}] A numeric vector of item sizes to be fit into bins. Each value
represents the size of an atomic item. If a value is \code{NA} it is
ignored and the corresponding result will also be \code{NA}.}

\item{cap}{[\code{numeric(1)}] A scalar value representing the bin capacity in units of values in \code{x}.
If an individual item size is above \code{cap} a single bin is reserved
for this item.}

\item{sort}{[\code{logical(1)}] Determines whether the input vector should be sorted in
decreasing order before applying the "First Fit" algorithm
("First Fit Decreasing").}
}
\value{
[\code{\link[=integer]{integer()}}] An integer vector of labels of the same length as \code{x}. The integer
label at position \code{i} determines the assignment of the \code{i}th item
with size \code{x[i]} to a bin. If the value \code{x[i]} is \code{NA} the result
label at position \code{i} will also be \code{NA}.
}
\description{
1D bin packing "First Fit (Decreasing)" algorithm
}
\details{
See \href{https://en.wikipedia.org/wiki/First-fit_bin_packing}{Wikipedia}
for a concise introduction or
"The Art of Computer Programming Vol. 1" by Donald E. Knuth
(1997, ISBN: 0201896834) for more details.
}
\examples{
# Generate a vector of item sizes
x <- sample(100, 1000, replace = TRUE)

# Pack those items into bins of capacity 130
bins <- bin_pack_ffd(x, cap = 130)

# Number of bins needed to pack the items
print(length(unique(bins)))

}
