% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estinternsp.R
\name{AuxVarGen}
\alias{AuxVarGen}
\title{Generate auxiliary variable for given proposed parameters.}
\usage{
AuxVarGen(kappa, theta, likelihoodprev, rho0sum, CC, AreaMRW, W_dil, niter)
}
\arguments{
\item{kappa}{parameter to generate auxiliary variable. \eqn{\kappa} represents the -.}

\item{theta}{parameter vector
\ifelse{html}{
\out{&Theta; = (&theta;<sub>1</sub>, &theta;<sub>2</sub>). &theta;<sub>1</sub> represents -. &theta;<sub>2</sub> represents-.}}{
\eqn{\Theta = (\theta_1, \theta_2). \theta_1 represents -. \theta_2 represents -.}
}.}

\item{likelihoodprev}{previous likelihood value.}

\item{rho0sum}{Initial sum of interaction strengths.}

\item{CC}{cluster centers.}

\item{AreaMRW}{area of dilated window.}

\item{W_dil}{observation window dilated by the assumed maximal cluster radius.}

\item{niter}{number of iterations of MCMC.}
}
\value{
The output is a list of \code{CC}, \code{likelihoodprev}, \code{rho0sum}.
}
\description{
Generate auxiliary variable for given proposed parameters.
}
