% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-trlpsptime.r
\docType{data}
\name{trlpsptime}
\alias{trlpsptime}
\title{Long term tree-list data from permanent sample plots}
\format{
Contains tree-level variables, as follows:
\describe{
\item{plot}{Plot number.}
\item{tree}{Tree identificator.}
\item{species}{Species code as follows:
PCAB=\emph{Picea abies}, LADC=\emph{Larix decidua}, PNSY=\emph{Pinus sylvestris},
FASY=\emph{Fagus Sylvatica}, QCPE=\emph{Quercus petraea}, BTPE=\emph{Betula pendula}.}
\item{year}{Year of measurement.}
\item{obs}{Observation.}
\item{dbh}{Diameter at breast-height, in mm.}
\item{dbh2}{Orthogonal measured second diameter, in mm.}
\item{hmk}{Selection criteria to measure tree height.
\code{1}=systematic, \code{2}=systematic and in the group of the 100 thickest,
\code{3}=belongs to the 100 thickest, \code{4}=lying tree, \code{5}=Standing tree with a ladder,
\code{6}=outlier, \code{7}=from stem analysis.}
\item{kh}{Type of the height measurement. \code{0}=tree height,
\code{1}=angle and distances.}
\item{ho}{Tree height in dm when \code{kh=0}. When \code{kh=1} then distance to the tree
in dm or in 1977 length of the base bar in cm.}
\item{ka}{Height to the crown base in dm when \code{kh=0}. When \code{kh=1} then angle
to the tree top in 1/10 degree.}
\item{kb}{Crown width in dm when \code{kh=0}. When \code{kh=1} then angle to 1.3 m
above tree base in 1/10 degree.}
\item{wka}{Angle to crown base in 1/10 degree.}
\item{crown.cl}{Crown class according to Kraft. \code{1}=predominant,
\code{2}=dominant, \code{3}=co-dominant, \code{4}=dominated, \code{5}=overtopped.}
\item{crown}{Crown quality. \code{0}=normal, \code{1}=broken in the crown region,
\code{2}=substituted tree top, \code{3}=forked, \code{4}=bushy, stork nest, witches' broom,
\code{5}=wizen tree top, \code{6}=again broken tree top.}
\item{stem}{Stem quality. \code{0}=typical, \code{1}=crooked, \code{2}=abiotic damaged,
\code{3}=biotic damaged, \code{4}=forked stem without damage, \code{5}=forked stem with damage,
\code{6}=up to 1/3 of the girth is peeled,
\code{7}=more than 1/3 of the girth is peeled,
\code{8}=broken stem, \code{9}=other stem damages.}
\item{defoliation}{crown defoliation. \code{1}=low, \code{2}=medium, \code{3}=much.}
}
}
\source{
The Austrian Research Center for Forests established a spacing experiment
with Norway spruce (\emph{Picea abies}) in the Vienna Woods. In the ``Hauersteig''
experiment, several tree-level variables were measured within four sample
plots over time.
Data were retrieved from the paper cited below, where several details
might be worth reading.
}
\usage{
data(trlpsptime)
}
\description{
Temporal tree-level data within four sample plots
in an experimental forest in Austria. The dataframe contains several
tree-level variables. Plot sizes are 2500 m\eqn{^{2}}{^2} (approx.).
}
\examples{
data(trlpsptime)
df<-trlpsptime
head(df)
tapply(df$dbh, list(df$year,df$plot), mean)
}
\references{
\itemize{
\item Kindermann G. Kristofel F, Neumann M, Rossler G, Ledermann T &
Schueler. 2018. 109 years  of forest growth measurements from
individual Norway spruce trees. Sci. Data 5:180077
\doi{10.1038/sdata.2018.77}
}
}
\keyword{datasets}
