% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clustering}
\alias{clustering}
\title{clustering}
\usage{
clustering(data, clusters=3, iter_max=10, restarts=1)
}
\arguments{
\item{data}{A biosensor object.}

\item{clusters}{Number of clusters.}

\item{iter_max}{Maximum number of iterations.}

\item{restarts}{Number of restarts.}
}
\value{
An object of class bclustering:
\code{data} A data frame with biosensor raw data.
\code{result} A kgroups object (see energy library).
}
\description{
Performs energy clustering with Wasserstein distance using quantile distributional representations as covariates.
}
\examples{
# Data extracted from the paper: Hall, H., Perelman, D., Breschi, A., Limcaoco, P., Kellogg, R.,
# McLaughlin, T., Snyder, M., Glucotypes reveal new patterns of glucose dysregulation, PLoS
# biology 16(7), 2018.
file1 = system.file("extdata", "data_1.csv", package = "biosensors.usc")
file2 = system.file("extdata", "variables_1.csv", package = "biosensors.usc")
data = load_data(file1, file2)
clus = clustering(data, clusters=3)
}
