% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_hubs.R
\name{sniff_groups_hubs}
\alias{sniff_groups_hubs}
\title{Identify Hub Papers in Research Groups}
\usage{
sniff_groups_hubs(groups, min_citations = 1)
}
\arguments{
\item{groups}{A list containing network data with the following components:
\itemize{
\item{network: A tidygraph network object}
\item{pubs_by_year: Publication counts by year}
\item{aggregate: Aggregate network statistics}
}}

\item{min_citations}{Minimum number of citations for a paper to be considered (default: 1)}
}
\value{
A tibble containing:
\itemize{
\item{group: Research group identifier}
\item{SR: Paper identifier}
\item{TC: Total citations}
\item{Ki: Total citations from all groups}
\item{ki: Citations from within the same group}
\item{Zi: Standardized within-group citation score}
\item{Pi: Citation diversity index}
\item{zone: Hub classification ("noHub", "R5", "R6", "R7")}
}
}
\description{
This function analyzes citation networks to identify hub papers within research groups
based on their citation patterns. It calculates several metrics (Zi, Pi) to classify
papers into different hub categories.
}
\details{
The function classifies papers into hub categories based on:
\itemize{
\item{R5: Knowledge hubs (Zi >= 2.5 and Pi <= 0.3)}
\item{R6: Bridging hubs (Zi >= 2.5 and 0.3 < Pi <= 0.75)}
\item{R7: Boundary-spanning hubs (Zi >= 2.5 and Pi > 0.75)}
}
}
\examples{
\dontrun{

# Assuming 'groups' is output from sniff_groups()

# Identify hub papers
hubs <- sniff_groups_hubs(groups, min_citations = 5)

# View results
head(hubs)
}

}
