% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-fit.R
\name{fit_one}
\alias{fit_one}
\title{Fit Single Bivariate Hurdle Model}
\usage{
fit_one(
  DT,
  k,
  spec = c("A", "B", "C", "D"),
  controls = character(0),
  model = NULL,
  output_dir = NULL,
  iter_warmup = 1000,
  iter_sampling = 1200,
  chains = 4,
  seed = NULL,
  adapt_delta = 0.95,
  max_treedepth = 12,
  threads_per_chain = 1L,
  hs_tau0 = 0.5,
  hs_slab_scale = 5,
  hs_slab_df = 4,
  verbose = TRUE
)
}
\arguments{
\item{DT}{A data.table with the data.}

\item{k}{Integer; lag order.}

\item{spec}{Character; model specification ("A", "B", "C", "D").}

\item{controls}{Character vector of control variable names.}

\item{model}{A compiled CmdStan model object. If NULL, the package
default model is loaded.}

\item{output_dir}{Directory for CmdStan output files. If NULL, uses
a temporary directory.}

\item{iter_warmup}{Integer; warmup iterations.}

\item{iter_sampling}{Integer; sampling iterations.}

\item{chains}{Integer; number of chains.}

\item{seed}{Integer; random seed.}

\item{adapt_delta}{Numeric; adaptation target acceptance rate.}

\item{max_treedepth}{Integer; maximum tree depth.}

\item{threads_per_chain}{Integer; threads per chain.}

\item{hs_tau0}{Numeric; horseshoe tau0 parameter.}

\item{hs_slab_scale}{Numeric; horseshoe slab scale.}

\item{hs_slab_df}{Numeric; horseshoe slab degrees of freedom.}

\item{verbose}{Logical; print progress messages.}
}
\value{
A list with components:
\item{fit}{The CmdStanMCMC fit object.}
\item{des}{The design matrices used.}
\item{spec}{The model specification.}
\item{k}{The lag order.}
\item{hs_tau0, hs_slab_scale, hs_slab_df}{Horseshoe hyperparameters.}
\item{controls}{Control variables used.}
\item{output_dir}{Directory with output files.}
}
\description{
Fits a bivariate hurdle negative binomial model with horseshoe
priors using Stan/CmdStan.
}
