% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{load_saved_results}
\alias{load_saved_results}
\title{Load Saved Results from Directory}
\usage{
load_saved_results(
  dir_out,
  which = c("varx", "tsdyn", "bma", "dbn", "hmm", "sensemakr", "synth"),
  verbose = TRUE
)
}
\arguments{
\item{dir_out}{Directory containing saved .rds files.}

\item{which}{Character vector specifying which results to load. Valid options:
"varx", "tsdyn", "bma", "dbn", "hmm", "sensemakr", "synth".
Default loads all available.}

\item{verbose}{Logical; if TRUE, print messages about loaded files.}
}
\value{
Named list of loaded objects. Components not found are NULL.
}
\description{
Loads previously saved .rds result files from a specified directory.
}
\examples{
\donttest{
# 1. Create a temporary directory (CRAN safe)
tmp_dir <- file.path(tempdir(), "test_results")
dir.create(tmp_dir, showWarnings = FALSE)

# 2. Create dummy data files matching the names expected by the function
saveRDS(list(aic = 100), file.path(tmp_dir, "varx_fit.rds"))
saveRDS(list(model = "BMA"), file.path(tmp_dir, "best_fit_bma.rds"))

# 3. Load the results (this will now work correctly)
results <- load_saved_results(tmp_dir, which = c("varx", "bma"))

# 4. Clean up
unlink(tmp_dir, recursive = TRUE)
}
}
