% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarise_varx_posthoc}
\alias{summarise_varx_posthoc}
\title{Summarise VARX model fit and diagnostics}
\usage{
summarise_varx_posthoc(varx_res)
}
\arguments{
\item{varx_res}{A list returned by \code{\link{run_varx}()}, typically
containing elements \code{$fit}, \code{$serial}, \code{$normal},
and \code{$arch}.}
}
\value{
A data frame with one row and columns:
\itemize{
\item \code{model}: constant string \code{"VARX"}.
\item \code{config}: textual description of the lag order and
exogenous variables.
\item \code{AIC}, \code{BIC}: information criteria.
\item \code{p_serial}, \code{p_normal}, \code{p_arch}: p-values
from diagnostic tests.
}
}
\description{
Produces a compact summary of a VARX model, including information
about lag order, exogenous variables, information criteria, and
selected diagnostic p-values.
}
\details{
The function extracts:
\itemize{
\item Lag order \code{p} from \code{fit$p}, if available.
\item AIC and BIC via \code{stats::AIC()} and \code{stats::BIC()}.
\item P-values from serial correlation, normality, and ARCH tests
using the helper \code{.first_pvalue()}.
}

If \code{varx_res} or \code{varx_res$fit} is \code{NULL}, a default
row with \code{NA} values is returned.
}
