% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zicreg-methods.R
\docType{class}
\name{zicreg-class}
\alias{zicreg-class}
\title{The zicreg S4 Class}
\description{
Note that \code{zicreg} objects are, in general, S3. However,
this S4 class is defined for compatability with \code{\link[texreg]{texreg}}.
Interaction with \code{zicreg} objects should generally use S3 syntax, but the below
objects have the same name in both the S3 and S4 objects (but are in a list for S3).
}
\section{Slots}{

\describe{
\item{\code{call}}{The original function call}

\item{\code{obj}}{The class of the object}

\item{\code{coef}}{Vector of coefficients, with count, then zi, then dispersion.}

\item{\code{se}}{Vector of asymptotic standard errors}

\item{\code{grad}}{Gradient vector at convergence}

\item{\code{link.ct}}{Name of link used for count portion}

\item{\code{link.zi}}{Name of link used for zero-inflated portion}

\item{\code{dist}}{Name of distribution used for count portion}

\item{\code{optimizer}}{Name of optimization package used in fitting}

\item{\code{coefmat.ct}}{Coefficient matrix for count portion}

\item{\code{coefmat.zi}}{Coefficient matrix for zero-inflated portion}

\item{\code{convergence}}{Convergence code from optimization routine.}

\item{\code{coefmat.all}}{Coefficient matrix for both parts of the model}

\item{\code{theta}}{Coefficient matrix for dispersion, if applicable.}

\item{\code{covmat}}{Asymptotic covariance matrix}

\item{\code{nobs}}{Number of observations}

\item{\code{aic}}{Akaike information}

\item{\code{bic}}{Bayes information}

\item{\code{loglik}}{Log-likelihood at convergence}

\item{\code{model}}{List containing model matrices if \code{keep = TRUE}}
}}

