% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorResponseFunctions.R
\name{PredictorResponseBivarPair}
\alias{PredictorResponseBivarPair}
\title{Plot bivariate predictor-response function on a new grid of points}
\usage{
PredictorResponseBivarPair(
  fit,
  y = NULL,
  Z = NULL,
  X = NULL,
  whichz1 = 1,
  whichz2 = 2,
  whichz3 = NULL,
  method = "approx",
  prob = 0.5,
  q.fixed = 0.5,
  sel = NULL,
  ngrid = 50,
  min.plot.dist = 0.5,
  center = TRUE,
  ...
)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{whichz1}{vector identifying the first predictor that (column of \code{Z}) should be plotted}

\item{whichz2}{vector identifying the second predictor that (column of \code{Z}) should be plotted}

\item{whichz3}{vector identifying the third predictor that will be set to a pre-specified fixed quantile (determined by \code{prob})}

\item{method}{method for obtaining posterior summaries at a vector of new points. Options are "approx" and "exact"; defaults to "approx", which is faster particularly for large datasets; see details}

\item{prob}{pre-specified quantile to set the third predictor (determined by \code{whichz3}); defaults to 0.5 (50th percentile)}

\item{q.fixed}{vector of quantiles at which to fix the remaining predictors in \code{Z}}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}

\item{ngrid}{number of grid points to cover the range of each predictor (column in \code{Z})}

\item{min.plot.dist}{specifies a minimum distance that a new grid point needs to be from an observed data point in order to compute the prediction; points further than this will not be computed}

\item{center}{flag for whether to scale the exposure-response function to have mean zero}

\item{...}{other arguments to pass on to the prediction function}
}
\value{
a data frame with value of the first predictor, the value of the second predictor, the posterior mean estimate, and the posterior standard deviation
}
\description{
Plot bivariate predictor-response function on a new grid of points
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)

## Obtain predicted value on new grid of points
## Using only a 10-by-10 point grid to make example run quickly
pred.resp.bivar12 <- PredictorResponseBivarPair(fit = fitkm, min.plot.dist = 1, ngrid = 10)
}
