% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkmr_main_functions.R
\name{summary.bkmrfit}
\alias{summary.bkmrfit}
\title{Summarizing BKMR model fits}
\usage{
\method{summary}{bkmrfit}(
  object,
  q = c(0.025, 0.975),
  digits = 5,
  show_ests = TRUE,
  show_MH = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class "bkmrfit"}

\item{q}{quantiles of posterior distribution to show}

\item{digits}{the number of digits to show when printing}

\item{show_ests}{logical; if \code{TRUE}, prints summary statistics of posterior distribution}

\item{show_MH}{logical; if \code{TRUE}, prints acceptance rates from the Metropolis-Hastings algorithm}

\item{...}{further arguments passed to or from other methods.}
}
\value{
No return value, prints more detailed summary of fit to console
}
\description{
\code{summary} method for class "bkmrfit"
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)
summary(fitkm)
}
