% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{compute_beta_sample}
\alias{compute_beta_sample}
\title{compute_beta_sample}
\usage{
compute_beta_sample(posterior_sample, param)
}
\arguments{
\item{posterior_sample}{a list provided by the function \code{Bliss_Gibbs_Sampler}.}

\item{param}{a list containing:
\describe{
\item{K}{a vector of integers, corresponding to the numbers of intervals for
      each covariate.}
\item{grids}{a numerical vector, the observation time points.}
\item{basis}{a character (optional) among : "uniform" (default),
      "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates.}
\item{Q}{an integer, the number of functional covariates.}
\item{p}{a vector of integers, the numbers of time points of each functional
     covariate.}
}}
}
\value{
a matrix containing the coefficient function posterior sample.
}
\description{
Compute the posterior coefficient function from the posterior
             sample.
}
\examples{
data(data1)
data(param1)
data(res_bliss1)
param1$grids <- data1$grids
param1$p <- sapply(data1$grids,length)
param1$Q <- length(data1$x)
beta_sample <- compute_beta_sample(posterior_sample=res_bliss1$posterior_sample,
                                   param=param1)
}
