% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd-schedule.R
\name{cmd_on_start}
\alias{cmd_on_start}
\alias{cmd_on_exit}
\alias{cmd_on_fail}
\alias{cmd_on_succeed}
\title{Schedule expressions to run}
\usage{
cmd_on_start(command, ...)

cmd_on_exit(command, ...)

cmd_on_fail(command, ...)

cmd_on_succeed(command, ...)
}
\arguments{
\item{command}{A \code{command} object.}

\item{...}{The expressions input will be captured with
\code{\link[rlang:enquo]{enquos()}}. If your expressions depend on global data, you
may want to unquote objects with \code{\link[rlang:injection-operator]{!!}} to prevent
unintended changes due to delayed evaluation.
\itemize{
\item \code{cmd_on_start}: Expression to be evaluated when the command started.
\item \code{cmd_on_exit}: Expression to be evaluated when the command finished.
\item \code{cmd_on_fail}: Expression to be evaluated when the command failed.
\item \code{cmd_on_succeed}: Expression to be evaluated when the command succeeded.
}}
}
\value{
\itemize{
\item \code{cmd_on_start}: The \code{command} object itself, with the start code updated.
}

\itemize{
\item \code{cmd_on_exit}: The \code{command} object itself, with the exit code updated.
}

\itemize{
\item \code{cmd_on_fail}: The \code{command} object itself, with the failure code updated.
}

\itemize{
\item \code{cmd_on_succeed}: The \code{command} object itself, with the successful code
updated.
}
}
\description{
Schedule expressions to run
}
\section{Functions}{
\itemize{
\item \code{cmd_on_start()}: define the startup code of the command

\item \code{cmd_on_exit()}: define the exit code of the command

\item \code{cmd_on_fail()}: define the failure code of the command

\item \code{cmd_on_succeed()}: define the successful code of the command

}}
