% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-id.R
\name{dock_id}
\alias{dock_id}
\alias{as_dock_panel_id}
\alias{as_obj_id}
\alias{as_block_panel_id}
\alias{as_ext_panel_id}
\alias{as_dock_handle_id}
\alias{as_block_handle_id}
\alias{as_ext_handle_id}
\title{ID utilities}
\usage{
dock_id(ns = NULL)

as_dock_panel_id(x)

as_obj_id(x)

as_block_panel_id(x)

as_ext_panel_id(x)

as_dock_handle_id(x)

as_block_handle_id(x)

as_ext_handle_id(x)
}
\arguments{
\item{ns}{Namespace prefix}

\item{x}{Object}
}
\value{
Coercion functions \code{as_block_panel_id()}, \code{as_ext_panel_id()},
\code{as_block_handle_id()} and \code{as_ext_handle_id()} return objects that inherit
from \code{block_panel_id}, \code{ext_panel_id}, \code{block_handle_id} and
\code{ext_handle_id} as classed character vectors. The less specific coercion
functions \code{as_dock_panel_id()} and \code{as_dock_handle_id()} return objects
that inherit from \code{dock_panel_id} and \code{dock_handle_id}, in addition to
a sub-class such as \code{block_panel_id} or \code{ext_panel_id} (in the case of
\code{as_dock_panel_id()}). If a mix of sub-classes is returned, this will be
represented by a list of classed character vectors. Finally, \code{as_obj_id()}
returns a character vector, as does \code{dock_id()}.
}
\description{
Objects, such as blocks and dock extensions carry their own IDs. These
can be converted into other ID types, such as panel IDs or "handle" IDs.
Panel IDs are used to refer to dock panels, while handle IDs provide
"handles" for DOM manipulations. All such IDs inherit from \code{dock_id} and
panel IDs additionally inherit from \code{dock_panel_id}, while handle IDs
inherit from \code{dock_handle_id}. For panel IDs, depending on whether the panel
is showing a block or an extension, the inheritance structure additionally
contains \code{block_panel_id} or \code{ext_panel_id}, respectively. Similarly, for
handle IDs, we have \code{block_handle_id} and \code{ext_handle_id}. All \code{dock_id}
objects can be converted back to native IDs, by calling \code{as_obj_id()}.
The utility function \code{dock_id()} returns a (possibly namespaced) ID of the
\code{dock} instance that is used to manage all visible panels.
}
\examples{
blks <- c(
  a = blockr.core::new_dataset_block(),
  b = blockr.core::new_head_block()
)

ext <- new_edit_board_extension()

as_dock_panel_id(blks)
as_dock_panel_id(ext)

identical(names(blks), as_obj_id(as_block_panel_id(blks)))

as_dock_handle_id(blks)
as_dock_handle_id(ext)

identical(names(blks), as_obj_id(as_block_handle_id(blks)))

}
