% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_wider.R
\name{new_pivot_wider_block}
\alias{new_pivot_wider_block}
\title{Pivot Wider block constructor}
\usage{
new_pivot_wider_block(
  names_from = character(),
  values_from = character(),
  id_cols = character(),
  values_fill = "",
  names_sep = "_",
  names_prefix = "",
  ...
)
}
\arguments{
\item{names_from}{Character vector specifying which column(s) to use for new
column names. Can be a single column or multiple columns.}

\item{values_from}{Character vector specifying which column(s) to use for cell
values. Can be a single column or multiple columns.}

\item{id_cols}{Character vector of columns that uniquely identify each row.
If empty (default), uses all columns not specified in names_from or values_from.}

\item{values_fill}{Optional value to use for missing combinations. Can be a
single value like "0" or "NA". Leave empty to keep missing values as NA.}

\item{names_sep}{Separator to use when names_from specifies multiple columns.
Default is "_".}

\item{names_prefix}{Optional prefix to add to all new column names.}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}}
}
\value{
A block object for pivot_wider operations
}
\description{
This block reshapes data from long to wide format by pivoting column values
into new columns (see \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}). This is the inverse operation
of pivot_longer.
}
\examples{
# Create a pivot wider block
new_pivot_wider_block()

if (interactive()) {
  # Basic usage with long format data
  library(blockr.core)
  long_data <- data.frame(
    id = rep(1:3, each = 3),
    measurement_type = rep(c("a", "b", "c"), 3),
    value = c(10, 15, 12, 20, 25, 22, 30, 35, 32)
  )
  serve(
    new_pivot_wider_block(
      names_from = "measurement_type",
      values_from = "value"
    ),
    data = list(data = long_data)
  )

  # With values_fill to replace NAs
  serve(
    new_pivot_wider_block(
      names_from = "measurement_type",
      values_from = "value",
      values_fill = "0"
    ),
    data = list(data = long_data)
  )

  # With custom names_prefix
  serve(
    new_pivot_wider_block(
      names_from = "measurement_type",
      values_from = "value",
      names_prefix = "measure_"
    ),
    data = list(data = long_data)
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}, \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}
}
