% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{new_slice_block}
\alias{new_slice_block}
\title{Slice block constructor}
\usage{
new_slice_block(
  type = "head",
  n = 5,
  prop = NULL,
  order_by = character(),
  with_ties = TRUE,
  weight_by = character(),
  replace = FALSE,
  rows = "1:5",
  by = character(),
  ...
)
}
\arguments{
\item{type}{Character string specifying slice type: "head", "tail", "min", "max", "sample", or "custom"}

\item{n}{Number of rows to select (default: 5). Mutually exclusive with prop.}

\item{prop}{Proportion of rows to select (0 to 1, default: NULL). When specified, n is ignored.}

\item{order_by}{Column name to order by (for slice_min/slice_max)}

\item{with_ties}{Logical, whether to include ties (for slice_min/slice_max)}

\item{weight_by}{Column name for weighted sampling (for slice_sample)}

\item{replace}{Logical, whether to sample with replacement (for slice_sample)}

\item{rows}{Custom row positions (for slice)}

\item{by}{Character vector of column names for grouping}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for slice operations
}
\description{
This block allows row selection using various dplyr slice functions
(see \code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[dplyr:slice]{dplyr::slice_head()}}, \code{\link[dplyr:slice]{dplyr::slice_tail()}},
\code{\link[dplyr:slice]{dplyr::slice_min()}}, \code{\link[dplyr:slice]{dplyr::slice_max()}}, \code{\link[dplyr:slice]{dplyr::slice_sample()}}).
Features reactive UI with immediate updates and comprehensive grouping support.
}
\examples{
# Create a slice block
new_slice_block(type = "head", n = 5)

if (interactive()) {
  # Basic usage
  library(blockr.core)
  serve(new_slice_block(), list(data = mtcars))

  # Select first 5 rows
  serve(new_slice_block(type = "head", n = 5), list(data = mtcars))

  # Select rows with highest mpg values
  serve(new_slice_block(type = "max", order_by = "mpg", n = 3), list(data = mtcars))

  # Random sampling
  serve(new_slice_block(type = "sample", n = 10, replace = FALSE), list(data = mtcars))
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}
}
