% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unite.R
\name{new_unite_block}
\alias{new_unite_block}
\title{Unite block constructor}
\usage{
new_unite_block(
  col = "united",
  cols = character(),
  sep = "_",
  remove = TRUE,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{col}{Name for the new united column. Default is "united".}

\item{cols}{Character vector of column names to unite together.
If empty (default), all columns will be available for selection.}

\item{sep}{Separator to use between values. Default is "_".}

\item{remove}{If TRUE (default), remove input columns from output data frame.}

\item{na.rm}{If TRUE, missing values will be removed prior to uniting each row.
Default is FALSE.}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}}
}
\value{
A block object for unite operations
}
\description{
This block combines multiple columns into a single column by pasting their
values together (see \code{\link[tidyr:unite]{tidyr::unite()}}). This is useful for creating composite
identifiers or labels from multiple fields.
}
\examples{
# Create a unite block
new_unite_block()

if (interactive()) {
  # Basic usage - combine first and last name
  library(blockr.core)
  people_data <- data.frame(
    first_name = c("John", "Jane", "Bob"),
    last_name = c("Doe", "Smith", "Johnson"),
    age = c(30, 25, 35)
  )
  serve(
    new_unite_block(
      col = "full_name",
      cols = c("first_name", "last_name"),
      sep = " "
    ),
    data = list(data = people_data)
  )

  # With custom separator
  serve(
    new_unite_block(
      col = "id",
      cols = c("first_name", "last_name"),
      sep = "-",
      remove = TRUE
    ),
    data = list(data = people_data)
  )

  # With NA removal
  data_with_na <- data.frame(
    prefix = c("Dr.", NA, "Prof."),
    first = c("John", "Jane", "Bob"),
    last = c("Doe", "Smith", "Johnson")
  )
  serve(
    new_unite_block(
      col = "full_name",
      cols = c("prefix", "first", "last"),
      sep = " ",
      na.rm = TRUE
    ),
    data = list(data = data_with_na)
  )
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}, \code{\link[tidyr:unite]{tidyr::unite()}}
}
