% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{grid_attractiveness}
\alias{grid_attractiveness}
\title{Extract all the attractivenesses from a collection of spatial interaction
models}
\usage{
grid_attractiveness(sim_list, ...)
}
\arguments{
\item{sim_list}{a collection of spatial interaction models, an object of
class \code{sim_list}}

\item{...}{additional parameters for the \code{\link[=attractiveness]{attractiveness()}} function}
}
\value{
a matrix of attractivenesses at the destination locations
}
\description{
The function extract attractivenesses from all the spatial interaction models
of the collection and returns them in a matrix in which each row corresponds
to a model and each column to a destination location.
}
\examples{
distances <- french_cities_distances[1:15, 1:15] / 1000 ## convert to km
production <- log(french_cities$population[1:15])
attractiveness <- log(french_cities$area[1:15])
all_flows <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1
)
g_Z <- grid_attractiveness(all_flows)
## should be 12 rows (3 times 4 parameter pairs) and 15 columns (15
## destination locations)
dim(g_Z)
}
\seealso{
\code{\link[=attractiveness]{attractiveness()}} and \code{\link[=grid_blvim]{grid_blvim()}}
}
