% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-dynamic.R
\name{grid_blvim}
\alias{grid_blvim}
\title{Compute a collection of Boltzmann-Lotka-Volterra model solutions}
\usage{
grid_blvim(
  costs,
  X,
  alphas,
  betas,
  Z,
  bipartite = TRUE,
  origin_data = NULL,
  destination_data = NULL,
  epsilon = 0.01,
  iter_max = 50000,
  conv_check = 100,
  precision = 1e-06,
  quadratic = FALSE,
  progress = FALSE
)
}
\arguments{
\item{costs}{a cost matrix}

\item{X}{a vector of production constraints}

\item{alphas}{a vector of return to scale parameters}

\item{betas}{a vector of cost inverse scale parameters}

\item{Z}{a vector of initial destination attractivenesses}

\item{bipartite}{when \code{TRUE} (default value), the origin and destination
locations are considered to be distinct. When \code{FALSE}, a single set of
locations plays the both roles. This has only consequences in functions
specific to this latter case such as \code{\link[=terminals]{terminals()}}.}

\item{origin_data}{\code{NULL} or a list of additional data about the origin
locations (see details)}

\item{destination_data}{\code{NULL} or a list of additional data about the
destination locations (see details)}

\item{epsilon}{the update intensity}

\item{iter_max}{the maximal number of steps of the BLV dynamic}

\item{conv_check}{number of iterations between to convergence test}

\item{precision}{convergence threshold}

\item{quadratic}{selects the update rule, see details.}

\item{progress}{if TRUE, a progress bar is shown during the calculation
(defaults to FALSE)}
}
\value{
an object of class \code{sim_list}
}
\description{
This function computes a collection of flows between origin locations and
destination locations using \code{\link[=blvim]{blvim()}} on a grid of parameters. The flows use
the same costs, same production constraints and same attractivenesses. Each
flow is computed using one of all the pairwise combinations between the alpha
values given by \code{alphas} and the beta values given by \code{betas}. The function
returns an object of class \code{sim_list} which contains the resulting flows.
}
\section{Location data}{
While models in this package do not use location data beyond \code{X} and \code{Z},
additional data can be stored and used when analysing spatial interaction
models.
\subsection{Origin and destination location names}{

Spatial interaction models can store names for origin and destination
locations, using \code{\link[=origin_names<-]{origin_names<-()}} and \code{\link[=destination_names<-]{destination_names<-()}}. Names
are taken by default from names of the cost matrix \code{costs}. More precisely,
\code{rownames(costs)} is used for origin location names and \code{colnames(costs)} for
destination location names.
}

\subsection{Origin and destination location positions}{

Spatial interaction models can store the positions of the origin and
destination locations, using \code{\link[=origin_positions<-]{origin_positions<-()}} and
\code{\link[=destination_positions<-]{destination_positions<-()}}.
}

\subsection{Specifying location data}{

In addition to the functions mentioned above, location data can be specified
directly using the \code{origin_data} and \code{destination_data} parameters. Data are
given by a list whose components are not interpreted excepted the following
ones:
\itemize{
\item \code{names} is used to specify location names and its content has to follow
the restrictions documented in \code{\link[=origin_names<-]{origin_names<-()}} and
\code{\link[=destination_names<-]{destination_names<-()}}
\item \code{positions} is used to specify location positions and its content has
to follow the restrictions documented in \code{\link[=origin_positions<-]{origin_positions<-()}} and
\code{\link[=destination_positions<-]{destination_positions<-()}}
}
}
}

\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(
  distances, production, c(1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness
)
all_flows
length(all_flows)
all_flows[[2]]
}
