% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_graph.R
\name{nd_graph}
\alias{nd_graph}
\alias{nd_graph.sim}
\title{Compute the Nystuen and Dacey graph for a spatial interaction model}
\usage{
nd_graph(sim, definition = c("ND", "RW"), ...)

\method{nd_graph}{sim}(sim, definition = c("ND", "RW"), ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{definition}{terminal definition, either \code{"ND"} (for Nystuen & Dacey,
default) or \code{"RW"} (for Rihll & Wilson), see details.}

\item{...}{additional parameters}
}
\value{
a data frame describing the Nystuen and Dacey graph a.k.a. the nodal
structure of a spatial interaction model
}
\description{
This function computes the most important flows in a spatial interaction
model according to the approach outlined by J. D. Nystuen and M. F. Dacey
(Nystuen & Dacey, 1961. In this work, a \emph{nodal flow} is the largest flow sent
from a non terminal location (based on the definition of terminals recalled
in \code{\link[=terminals]{terminals()}}). The \emph{nodal structure} is the collection of those flows.
They form an oriented graph that has interesting properties. In particular
each weakly connected component contains a single terminal location which can
be seen as the dominant location of the component. Notice that because nodal
flows are based on terminals, this function applies only to the non bipartite
setting.
}
\details{
In practice, the function computes first the terminals and non terminals
according to either Nystuen & Dacey (1961) or Rihll and Wilson (1991). Then
it extracts the nodal flows. The result of the analysis is returned as a data
frame with three columns:
\itemize{
\item \code{from}: the index of the non terminal origin location
\item \code{to}: the index of destination location of the nodal flow of \code{from}
\item \code{flow}: the value of the nodal flow
}

An important aspect of the node structure is that is does not contain
isolated terminals. If a location is a terminal but is never the receiver of
a nodal flow it will not appear in the collection of nodal flows. It
constitutes a a trivial connected component in itself.
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- rep(1, 10)
model <- blvim(distances, production, 1.3, 1 / 250, attractiveness,
  bipartite = FALSE
)
destination_names(model) <- french_cities$name[1:10]
nd_graph(model)
dist_times <- french_cities_times[1:15, 1:15]
tmodel <- blvim(dist_times, rep(1, 15), 1.3, 1 / 5000, rep(1, 15),
  bipartite = FALSE
)
destination_names(tmodel) <- french_cities$name[1:15]
terminals(tmodel, definition = "RW")
nd_graph(tmodel, "RW")
}
\references{
Nystuen, J.D. and Dacey, M.F. (1961), "A graph theory
interpretation of nodal regions", Papers and Proceedings of the Regional
Science Association 7: 29-42. \doi{10.1007/bf01969070}

Rihll, T., and Wilson, A. (1991), "Modelling settlement structures in
ancient Greece: new approaches to the polis", In City and Country in the
Ancient World, Vol. 3, Edited by J. Rich and A. Wallace-Hadrill, 58-95.
London: Routledge.
}
\seealso{
\code{\link[=sim_is_bipartite]{sim_is_bipartite()}}, \code{\link[=is_terminal]{is_terminal()}}, \code{\link[=terminals]{terminals()}}
}
