% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apc.R
\name{apc}
\alias{apc}
\title{All pairwise comparisons}
\usage{
apc(ngroups, labs = NULL)
}
\arguments{
\item{ngroups}{A positive integer greater than 1 denoting the number of groups}

\item{labs}{A vector of groups labels with length equal to \code{ngroups}. The default is set to \code{NULL}, and if used, the labels will be set to \code{1:length(ngroups)}.}
}
\value{
The function returns a matrix of all pairwise contrasts.
}
\description{
Function creates a contrast matrix for all pairwise comparisons
}
\examples{
### A contrast matrix based on all pairwise contrasts of 5 groups
apc(5)

### Adding group labels
apc(5, labs = paste("Group", 1:5, sep = " "))

}
