% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varDecomp.R
\name{varDecomp}
\alias{varDecomp}
\title{Variance decomposition for fitted bml models}
\usage{
varDecomp(model, uncertainty = "sd", r = 2)
}
\arguments{
\item{model}{A fitted model object of class \code{"bml"} returned by \code{\link{bml}}.
Must have been fitted with \code{monitor = TRUE} (the default).}

\item{uncertainty}{Uncertainty measure to report. One of \code{"sd"} (posterior
standard deviation, the default), \code{"mad"} (median absolute deviation), or
\code{"ci"} (95\% credible interval with lower/upper bounds).}

\item{r}{Number of decimal places for rounding numeric output. Default: 2.}
}
\value{
A data frame of class \code{"bml_varDecomp"} with one row per variance
  component. Always includes \code{Component}, \code{sigma}, and \code{ICC} columns.
  Additional columns depend on \code{uncertainty}:
  \itemize{
    \item \code{"sd"}: \code{sigma_sd} and \code{ICC_sd}
    \item \code{"mad"}: \code{sigma_mad} and \code{ICC_mad}
    \item \code{"ci"}: \code{sigma_lb}, \code{sigma_ub}, \code{ICC_lb}, \code{ICC_ub}
  }
}
\description{
Computes a posterior variance decomposition and intraclass correlation
coefficients (ICCs) from a fitted \code{bml} model. The function automatically
discovers all variance components (sigma parameters) in the model, applies
weight adjustments for multiple-membership levels, and returns posterior
summaries.
}
\details{
\strong{Variance decomposition.}
The total variance of the outcome is partitioned into additive components,
one for each level in the model:

\deqn{\mathrm{Var}(y) = \sigma_1^2 + \sigma_2^2 + \ldots}

Each component contributes variance \eqn{\sigma^2}, except for multiple-membership (MM) levels,
where the effective variance contribution is scaled by the average of the summed squared weights
across groups.

\deqn{\mathrm{Var}_{\mathrm{mm}} = \sigma_{\mathrm{mm}}^2 \cdot \overline{w^2},
\quad \overline{w^2} = \frac{1}{N} \sum_{i=1}^{N} \sum_{k} w_{ik}^2}

This weight adjustment accounts for the fact that the member-level variance is
distributed across multiple members with potentially unequal influence. With
equal weights (\eqn{w_{ik} = 1/n_i}), the effective variance shrinks as group
size increases.

\strong{Intraclass Correlation Coefficient (ICC).}
The ICC for a given level is the proportion of total variance attributable to
that level:

\deqn{\rho_l = \frac{\sigma_l^2}{\sum_{l'} \sigma_{l'}^2}}

Intuitively, the ICC answers: "What fraction of the total variation in the
outcome is due to differences between units at this level?" An ICC of 0.30
for the country level, for example, means that 30\% of the outcome variation
can be attributed to between-country differences.

ICCs are computed per posterior draw and then summarized, properly propagating
uncertainty from the MCMC samples.

\strong{Family-specific handling:}
\itemize{
  \item \strong{Gaussian / Weibull}: The residual \code{sigma} from the model
    is used directly.
  \item \strong{Binomial}: There is no residual sigma. The latent logistic
    residual variance \eqn{\pi^2/3 \approx 3.29} is used instead.
  \item \strong{Cox}: There is no residual variance. ICCs are computed among
    the non-residual components only.
}
}
\examples{
\donttest{
data(coalgov)

m1 <- bml(
  Surv(dur_wkb, event_wkb) ~ 1 + majority +
    mm(id = id(pid, gid), vars = vars(cohesion), fn = fn(w ~ 1/n), RE = TRUE) +
    hm(id = id(cid), type = "RE"),
  family = "Weibull",
  data = coalgov
)

varDecomp(m1)
varDecomp(m1, uncertainty = "ci")
varDecomp(m1, uncertainty = "mad")
}

}
\seealso{
\code{\link{bml}}, \code{\link{summary.bml}}
}
\author{
Benjamin Rosche <benrosche@nyu.edu>
}
