% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-loo.R
\name{BMSC_pareto_k_table}
\alias{BMSC_pareto_k_table}
\alias{BMSC_pareto_k_ids}
\alias{BMSC_mcse_loo}
\alias{BMSC_pareto_k_values}
\alias{BMSC_pareto_k_influence_values}
\alias{BMSC_psis_n_eff_values}
\alias{print.pareto_k_table_BMSC}
\alias{print.pareto_k_ids_BMSC}
\alias{print.pareto_k_values_BMSC}
\alias{print.pareto_k_influence_values_BMSC}
\alias{print.psis_n_eff_values_BMSC}
\alias{print.mcse_loo_BMSC}
\title{bmscstan wrapper for diagnostics for Pareto smoothed importance
sampling (PSIS)}
\usage{
BMSC_pareto_k_table(x)

BMSC_pareto_k_ids(x, threshold = 0.5)

BMSC_mcse_loo(x, threshold = 0.7)

BMSC_pareto_k_values(x)

BMSC_pareto_k_influence_values(x)

BMSC_psis_n_eff_values(x)

\method{print}{pareto_k_table_BMSC}(x, ...)

\method{print}{pareto_k_ids_BMSC}(x, ...)

\method{print}{pareto_k_values_BMSC}(x, ...)

\method{print}{pareto_k_influence_values_BMSC}(x, ...)

\method{print}{psis_n_eff_values_BMSC}(x, ...)

\method{print}{mcse_loo_BMSC}(x, ...)
}
\arguments{
\item{x}{An object of class \code{loo_BMSC}}

\item{threshold}{for the `pareto_k_ids` method is the minimum $k$ value to flag.
for the `mcse_loo` method all the $k$ values greater than the
`threshold` will be returned as NA.}

\item{...}{further arguments passed to the `print` function.}
}
\value{
\itemize{
  \item{pareto_k_table}{ returns an object of class "pareto_k_table_BMSC",
     which is a matrix with columns "Count", "Proportion", and "Min. n_eff"
     }
  \item{pareto_k_ids}{ returns an integer vector indicating which observations
     have Pareto k estimates above threshold
     }
  \item{mcse_loo}{ returns the Monte Carlo standard error (MCSE) estimate for
     PSIS-LOO.
     MCSE will be NA if any Pareto kk values are above threshold.
     }
  \item{pareto_k_values}{ returns a vector of the estimated Pareto k parameters.
     These represent the reliability of sampling.
     }
  \item{pareto_k_influence_values}{ returns a vector of the estimated Pareto
     k parameters.
     These represent influence of the observations on the model
     posterior distribution.
     }
  \item{psis_k_influence_table}{ returns a vector of the estimated PSIS
     effective sample sizes.
     }
}
}
\description{
bmscstan wrapper for diagnostics for Pareto smoothed importance
sampling (PSIS)
}
