#' gasifier Bayesian Network
#'
#' Failure risk assessment of coal gasifier based on the integration of bayesian network and trapezoidal intuitionistic fuzzy number-based similarity aggregation method (TpIFN-SAM).
#' @usage NULL
#'
#' @format
#' A discrete Bayesian network for the failure-risk assessment of process system. Probabilities were given within the referenced paper. The vertices are:
#' \describe{
#'   \item{AbnormalCoalWater}{Abnormal flow rate of coal water (Occurred, NotOccured);}
#'   \item{AbnormalLiquidLevel}{Abnormal liquid level (Occurred, NotOccured);}
#'   \item{AbnormalQuenchWater}{Abnormal flow rate of quench water (Occurred, NotOccured);}
#'   \item{AbnormalTemperature}{Abnormal temperature (Occurred, NotOccured);}
#'   \item{AntiCorrosion}{Anti-corrosion layer damaged (Occurred, NotOccured);}
#'   \item{BurnerDamaged}{Burner damaged (Occurred, NotOccured);}
#'   \item{CorrosionFailure}{Corrosion failure (Occurred, NotOccured);}
#'   \item{Cracking}{Cracking in the quench ring or vertical pipe (Occurred, NotOccured);}
#'   \item{DeliberateDestruction}{Deliberate destruction (Occurred, NotOccured);}
#'   \item{ExternalCorrosion}{External corrosion (Occurred, NotOccured);}
#'   \item{FurnaceBricks}{Slag opening blocked by molten furnace bricks (Occurred, NotOccured);}
#'   \item{GasifierAbnormality}{Gasifier abnormality (Occurred, NotOccured);}
#'   \item{GasifierFailure}{Gasifier failure (Occurred, NotOccured);}
#'   \item{GaugeDamaged}{Liquid-level gauge damaged by blockage (Occurred, NotOccured);}
#'   \item{HighCO2}{High CO2 content (Occurred, NotOccured);}
#'   \item{HighConcentration}{High concentration of coal slurry (Occurred, NotOccured);}
#'   \item{HighFlow}{High flow rate (Occurred, NotOccured);}
#'   \item{HighFlowRate}{High flow rate of coal slurry (Occurred, NotOccured);}
#'   \item{HighH2O}{High H2O content (Occurred, NotOccured);}
#'   \item{HighH2S}{High H2S content (Occurred, NotOccured);}
#'   \item{HighOxygen}{High oxygen-flow rate (Occurred, NotOccured);}
#'   \item{HumanOrganization}{Human organization factors (Occurred, NotOccured);}
#'   \item{ImproperOperation}{Improper operation (Occurred, NotOccured);}
#'   \item{Insulation}{Insulation layer damaged (Occurred, NotOccured);}
#'   \item{InternalCorrosion}{Internal corrosion (Occurred, NotOccured);}
#'   \item{Leakage}{Leakage of drain valve of quench water (Occurred, NotOccured);}
#'   \item{LowConcentration}{Low concentration of coal slurry (Occurred, NotOccured);}
#'   \item{LowFlowRate}{Low flow rate of coal slurry (Occurred, NotOccured);}
#'   \item{LowLiquidLevel}{Low liquid rate in quench chamber (Occurred, NotOccured);}
#'   \item{LowOxygen}{Low oxygen-flow rate (Occurred, NotOccured);}
#'   \item{MediumContent}{Medium content (Occurred, NotOccured);}
#'   \item{PiecesOfSlag}{Slag opening blocked by large pieces of slage (Occurred, NotOccured);}
#'    \item{PreJobTraining}{Pre-job training is not up to standard (Occurred, NotOccured);}
#'     \item{PressureFluctuation}{Pressure fluctuation (Occurred, NotOccured);}
#'      \item{SensorDamaged1}{Temperature sensor damaged (Occurred, NotOccured);}
#'       \item{TemperatureSensor}{Temperature sensor damaged (Occurred, NotOccured);}
#'        \item{TooHighTemperature}{Too-high temperature (Occurred, NotOccured);}
#'         \item{TooLowTemperature}{Too-low temperature (Occurred, NotOccured);}
#'          \item{Unattended}{Unattended/unsafe supervision (Occurred, NotOccured);}
#'           \item{UnintentionalDestruction}{Unintentional destruction (Occurred, NotOccured);}
#'   }
#'
#'@keywords ReverseTree
#'
#' @return An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
#' @importClassesFrom bnlearn bn.fit
#' @references Liu, Y., Wang, S., Liu, Q., Liu, D., Yang, Y., Dan, Y., & Wu, W. (2022). Failure risk assessment of coal gasifier based on the integration of bayesian network and trapezoidal intuitionistic fuzzy number-based similarity aggregation method (TpIFN-SAM). Processes, 10(9), 1863.
"gasifier"
