% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymeasure.R
\name{asy_measure}
\alias{asy_measure}
\title{Measures of asymmetric independence}
\usage{
asy_measure(bnfit, node)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}

\item{node}{a node of \code{bnfit}.}
}
\value{
A list where each entry refers to one of the parent of \code{node}. Each entry of the list is a dataframe with the index of context-specific independence for each outcome of the conditioning parent in one column and in additional column the index of partial independence in the case of non-binary variables.
}
\description{
Computation of the indexes of context-specific and partial independence in a conditional probability table.
}
\details{
The index of context-specific independence computes the upper diameter of a CPT where all parents but one are fixed, while the index of partial independence computes the lower diameter for the same CPT. If the lower diameter is close to zero it means that there are at least two rows of the CPT which are very similar to each other, thus implying a partial conditional independence.
}
\examples{
asy_measure(synthetic_bn, "y3")

}
\references{
Leonelli, M., Smith, J. Q., & Wright, S. K. (2024). The diameter of a stochastic matrix: A new measure for sensitivity analysis in Bayesian networks. arXiv preprint arXiv:2407.04667.

Pensar, J., Nyman, H., Lintusaari, J., & Corander, J. (2016). The role of local partial independence in learning of Bayesian networks. International Journal of Approximate Reasoning, 69, 91-105.
}
\seealso{
\code{\link{diameter}}
}
