% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.strap.bn.R
\name{boot.strap.bn}
\alias{boot.strap.bn}
\title{Executes a bootstrap during the learning of a BN structure}
\usage{
boot.strap.bn(bn.algorithm, bn.score.test, data.to.work, black.list,
  white.list, nreplicates = 1000, type.of.algorithm, outcome.var)
}
\arguments{
\item{bn.algorithm}{is a list of algorithms to learn the BN structure.}

\item{bn.score.test}{is list of conditional independence tests and the network scores to be used.}

\item{data.to.work}{is a data from which the BN structure will be learned.}

\item{black.list}{is a list of forbiden connections of BN structure to be created.}

\item{white.list}{is a list of mandatory connections of BN structure to be created.}

\item{nreplicates}{is the number of replications to be done in the bootstrap process.}

\item{type.of.algorithm}{is the type of algorithm to learn the BN sctructure, it would be constrained or score based.}

\item{outcome.var}{is the variable to be used as outcome (dependent) and be highlighted in the BN.}
}
\value{
The final BN structure learned.
}
\description{
This function receives a list of parameters, executes the bootstrap process and learn the Bayesian Network (BN) from the data set, then executes the process of model averaging to extract the final BN structure and print it.
}
\examples{
\dontrun{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Use working data sets from package
data(dataQualiN)
# Start the cluster
cl <- bnpa::create.cluster()
# Set the number of replications
nreplicates=1000
# Set the algorithm to be used
bn.algorithm="hc"
# Executes a parallel bootstrap process
data.bn.boot.strap=bnlearn::boot.strength(data = dataQualiN, R = nreplicates, algorithm =
bn.algorithm, cluster=cl, algorithm.args=list(score="bic"), cpdag = FALSE)
# Release the cluster
parallel::stopCluster(cl)
head(data.bn.boot.strap)
}
}
\references{
Claeskens N, Hjort N (2009) Model selection and model avaraging. Cambridge University Press, Cambridge, England.

Koller D, Friedman N (2009) Probabilistic graphical models: principles and techniques. MIT Press, Cambridge.

Scutari M (2017). Bayesian Network Constraint-Based Structure Learning Algorithms: Parallel and Optimized Implementations in the bnlearn R Package. Journal of Statistical Software, 77(2), 1-20.
}
\author{
Elias Carvalho
}
