% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.levels.one.variable.R
\name{check.levels.one.variable}
\alias{check.levels.one.variable}
\title{Check the levels of a categorical variable}
\usage{
check.levels.one.variable(data.to.work, variable.name)
}
\arguments{
\item{data.to.work}{is a data set with variable.}

\item{variable.name}{is the name of variable to be checked.}
}
\description{
This function receives a data set and a variable name, check the type of variable to be sure it is categorical (factor) and then count the number of levels it has.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Use working data sets from package
data(dataQualiN)
head(dataQualiN)
# Adding random data to dataQualiN, function will return TRUE
dataQualiN$Z <- round(runif(500, min=0, max=1000),2)
# Converting the numeric variable into factor
dataQualiN$Z <- factor(dataQualiN$Z)
# Set the variable name to a non categorical one
variable.name = "Z"
# Count the number o levels of a specific variable
number.of.levels <- check.levels.one.variable(dataQualiN, variable.name)
number.of.levels
# Set the variable name to a categorical variable
variable.name = "A"
# Count the number o levels of a specific variable
number.of.levels <- check.levels.one.variable(dataQualiN, variable.name)
number.of.levels
}
\references{
GUJARATI, Damodar N. Basic econometrics. Tata McGraw-Hill Education, 2009.
}
\author{
Elias Carvalho
}
