% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_location_xml.R
\name{get_location_xml}
\alias{get_location_xml}
\title{Return XML vehicle location data from the 'BODS' API}
\usage{
get_location_xml(
  api_key = Sys.getenv("BODS_KEY"),
  bounding_box = NULL,
  noc = NULL,
  vehicle_ref = NULL,
  line_ref = NULL,
  producer_ref = NULL,
  origin_ref = NULL,
  destination_ref = NULL
)
}
\arguments{
\item{api_key}{API key for the 'BODS' dataset passed as a string. Can be obtained from \href{https://data.bus-data.dft.gov.uk/api/}{the 'BODS' API login}}

\item{bounding_box}{vector of four numerics. Limit results to location data
for vehicles within the rectangular boundingBox
you set using co-ordinates [minLatitude, maxLatitude, minLongitude, maxLongitude].
Defaults to NULL.}

\item{noc}{string or vector of strings. Limit results to fares data sets for specified National Operator Codes.
A full lookup of NOC to bus operator names can be seen using noc_lookup().
Defaults to NULL.}

\item{vehicle_ref}{string. Limit results to bus location data with the
specified vehicle_ref. This is a unique reference for the vehicle that is
consistent and is generated by the vehicle equipment. Defaults to NULL.}

\item{line_ref}{string. Limit results to bus location data with the
specified line_ref. Defaults to NULL.}

\item{producer_ref}{string. Limit results to bus location data with the
specified producer_ref. Defaults to NULL.}

\item{origin_ref}{string. Limit results to bus location data with the
specified origin reference. Accepts any National Public Transport Access Nodes (NaPTAN) value,
which can be found \href{https://www.data.gov.uk/dataset/ff93ffc1-6656-47d8-9155-85ea0b8f2251/national-public-transport-access-nodes-naptan}{the NaPTAN access nodes dataset}.
Defaults to NULL.}

\item{destination_ref}{string. Limit results to bus location data with the
specified destination reference. Accepts any National Public Transport Access Nodes (NaPTAN) value,
which can be found \href{https://www.data.gov.uk/dataset/ff93ffc1-6656-47d8-9155-85ea0b8f2251/national-public-transport-access-nodes-naptan}{the NaPTAN access nodes dataset}.
Defaults to NULL.}
}
\value{
Returns bus location data in XML SIRI-VM format. More detail on this format can be found \href{https://data.bus-data.dft.gov.uk/guidance/requirements/?section=dataformats}{the 'BODS' data formats documentation}
}
\description{
Return XML vehicle location data from the 'BODS' API
}
\examples{

\dontrun{
#Before running these examples, ensure you have an API key saved

##Return unfiltered data from XML API
get_location_xml()

#Return data for vehicle reference "BUSC" only
get_location_xml(vehicle_ref = "BUSC")

#Return data for specified origin
get_location_xml(origin_ref = "21024515")

}
}
