% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_values.R
\name{reference_percentiles}
\alias{reference_percentiles}
\title{Get percentile(s) for a given combination of model and measurement}
\usage{
reference_percentiles(
  metric,
  sex,
  level,
  age,
  measurement,
  verbose = FALSE,
  digits = 0
)
}
\arguments{
\item{metric}{character (vector), body composition metric}

\item{sex}{character (vector), "Female" or "Male"}

\item{level}{character (vector), used vertebral level}

\item{age}{integer (vector), age}

\item{measurement}{numeric (vector), raw value of measurement}

\item{verbose}{logical, should messages be discplayed}

\item{digits}{integer, digits to round percentile to}
}
\value{
numeric, corresponding percentile
}
\description{
For a given constellation of metric, sex, vertebral level, and age returns the corresponding percentiles for a given measurement
}
\examples{
\dontshow{if (requireNamespace("adiposerefdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
reference_percentiles(metric=c("CSFA", "CSFA"), sex=c("Female","Male"),
                 level=c("T5","L3"), age=c(42,68), measurement=c(50,50))
\dontshow{\}) # examplesIf}
}
\seealso{
[bodycomp_reference()]
}
\author{
J. Peter Marquardt
}
