% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliography-support.R
\name{boilerplate_add_bibliography}
\alias{boilerplate_add_bibliography}
\title{Add Bibliography to Database}
\usage{
boilerplate_add_bibliography(db, url, local_path = NULL, validate = TRUE)
}
\arguments{
\item{db}{Database object}

\item{url}{URL to the bibliography file}

\item{local_path}{Local filename to use when copying (default: basename of URL)}

\item{validate}{Whether to validate citations on updates}
}
\value{
Updated database object
}
\description{
Adds or updates bibliography information in a boilerplate database.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and import
boilerplate_init(data_path = temp_dir, create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Add bibliography
# Using the example bibliography included with the package
example_bib <- system.file("extdata", "example_references.bib", package = "boilerplate")
db <- boilerplate_add_bibliography(
  db,
  url = paste0("file://", example_bib),
  local_path = "references.bib"
)

# Save the updated database
boilerplate_save(db, data_path = temp_dir, confirm = FALSE, quiet = TRUE)

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
