% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project-functions.R
\name{boilerplate_copy_from_project}
\alias{boilerplate_copy_from_project}
\title{Copy Elements from One Project to Another}
\usage{
boilerplate_copy_from_project(
  from_project,
  to_project,
  paths = NULL,
  prefix = NULL,
  data_path = NULL,
  merge_strategy = c("skip", "overwrite", "rename"),
  confirm = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{from_project}{Character. Name of the source project.}

\item{to_project}{Character. Name of the destination project.}

\item{paths}{Character vector. Paths to copy (e.g., c("measures.anxiety", "methods.sampling")).
If NULL, copies everything (requires confirmation).}

\item{prefix}{Character. Optional prefix to add to copied entries to avoid conflicts.
For example, prefix = "colleague_" would rename "anxiety" to "colleague_anxiety".}

\item{data_path}{Character. Base path for boilerplate data. If NULL, uses default location.}

\item{merge_strategy}{Character. How to handle conflicts: "skip", "overwrite", or "rename".}

\item{confirm}{Logical. If TRUE, asks for confirmation. Default is TRUE.}

\item{quiet}{Logical. If TRUE, suppresses messages. Default is FALSE.}
}
\value{
Invisibly returns the updated database from the destination project.
}
\description{
This function allows selective copying of boilerplate elements from one project
to another, enabling controlled sharing of content between projects.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise two projects
boilerplate_init(data_path = temp_dir, project = "colleague_measures",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
boilerplate_init(data_path = temp_dir, project = "my_research",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)

# Add some content to source project
source_db <- boilerplate_import(data_path = temp_dir,
                                 project = "colleague_measures", quiet = TRUE)
source_db$measures$anxiety <- list(name = "Anxiety Scale", items = 10)
source_db$measures$depression <- list(name = "Depression Scale", items = 20)
boilerplate_save(source_db, data_path = temp_dir,
                 project = "colleague_measures", confirm = FALSE, quiet = TRUE)

# Copy specific measures from colleague's project
boilerplate_copy_from_project(
  from_project = "colleague_measures",
  to_project = "my_research",
  paths = c("measures.anxiety", "measures.depression"),
  prefix = "smith_",
  data_path = temp_dir,
  confirm = FALSE,
  quiet = TRUE
)

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
