% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibliography-support.R
\name{boilerplate_validate_references}
\alias{boilerplate_validate_references}
\title{Validate References in boilerplate Database}
\usage{
boilerplate_validate_references(
  db,
  bib_file = NULL,
  categories = c("methods", "results", "discussion", "appendix"),
  quiet = FALSE
)
}
\arguments{
\item{db}{Database object to validate}

\item{bib_file}{Path to bibliography file. If NULL, will try to download from database}

\item{categories}{Character vector of categories to check.
Default is all text categories.}

\item{quiet}{Logical. Suppress detailed messages}
}
\value{
List with validation results including used keys, available keys, and missing keys
}
\description{
Checks that all citations in the boilerplate text exist in the bibliography file.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and import
boilerplate_init(data_path = temp_dir, create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Validate references
validation <- boilerplate_validate_references(db)
if (length(validation$missing) > 0) {
  warning("Missing references: ", paste(validation$missing, collapse = ", "))
}

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
