% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/33_computingQuotedDiscRateMMI.R
\name{computingQuotedDiscRateMMI}
\alias{computingQuotedDiscRateMMI}
\title{Calculates Discount Rate of Money Market Instrument.}
\usage{
computingQuotedDiscRateMMI(pvMmi, fvMmi, daysToMaturity, daysInYear)
}
\arguments{
\item{pvMmi}{A number.}

\item{fvMmi}{A number.}

\item{daysToMaturity}{A number.}

\item{daysInYear}{A number.}
}
\value{
Input values to four arguments  \code{pvMmi} ,\code{fvMmi}, \code{daysToMaturity} and  \code{daysInYear}.
}
\description{
Calculates Discount Rate of Money Market Instrument.
}
\details{
It is important to understand that discount rate has a unique meaning in the money market. In general, discount rate means interest rate used to calculate a present value such as market discount rate. In the money market however, discount rate is a specific type of quoted rate (Adams & Smith, 2019).
Based on the given information, the method \code{computingQuotedDiscRateMMIr()} is developed to compute Discount Rate of Money Market Instrument for the values passed to its four arguments. Here, \code{pvMmi} is present value of the Money Market Instrument, \code{fvMmi} is future value of the Money Market Instrument (that is sale price and not the redemption amount), \code{daysToMaturity} is number of days till the maturity, and \code{daysInYear} is taken to be 360. For example, an output value of 0.0225 represents a quoted discount rate of 2.25 percent for an assumed 360-day year.
}
\examples{
computingQuotedDiscRateMMI(pvMmi=9943125,fvMmi=10000000,daysToMaturity=91,daysInYear=360)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
