% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive.R
\name{naive}
\alias{naive}
\title{Naive Model Estimation}
\usage{
naive(
  resp,
  trt,
  subgr,
  data,
  resptype = c("survival", "binary"),
  status = NULL
)
}
\arguments{
\item{resp}{(\code{string})\cr the response variable name.}

\item{trt}{(\code{string})\cr the treatment variable name. The treatment variable
must be a factor with 2 levels where the first level is the control and the
second one the treatment.}

\item{subgr}{(\code{character})\cr vector with the name of the subgrouping
variables. These variables have to be \code{factor} variables with the subgroups
as levels.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}

\item{resptype}{(\code{string})\cr the type of data used. Can be "survival"
or "binary".}

\item{status}{(\code{string})\cr only for "survival" \code{resptype},
the status variable name in survival data.}
}
\value{
List with \code{fit}, \code{estimates}, \code{model}, \code{resptype}, \code{data}.
}
\description{
Function to fit the naive models to the data of each one of the subgroups.
}
\examples{
naive("tt_pfs", "arm", c("x_1", "x_2"), example_data, "survival", "ev_pfs")
}
