% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.sub.R
\name{block.sub}
\alias{block.sub}
\title{Block Subsampling}
\usage{
block.sub(x, func, length.block, method = c("movingblock", "circular"), ...)
}
\arguments{
\item{x}{A numeric vector or time series data.}

\item{func}{The function to apply to each block.}

\item{length.block}{A scalar or a vector indicating the lengths of the blocks.}

\item{method}{A character string specifying the type of block subsampling method.
Can be \code{"movingblock"} or \code{"circular"}:
\describe{
\item{\code{"movingblock"}}{divides the series into overlapping blocks.}
\item{\code{"circular"}}{wraps the time series around a circle to create Circular Moving Blocks.}
}}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
A matrix containing, in rows, the value of \code{func} applied to
each block. The number of columns in the matrix is equal to the length
of the output of the \code{func} function.
}
\description{
Block Subsampling for Time Series Using Blocks of Observations.
}
\details{
This function performs block subsampling on time series data using
the Moving or Circular Blocks methods (see Politis et al., 1999).
It applies the specified function \code{func} to each subsample block whose
length are defined by \code{length.block}.
The function \code{func} is applied to the vector \code{x} and may return either a real number or
a vector.
}
\examples{
set.seed(123) 
data <- rnorm(100) 
result <- block.sub(data, mean, length.block = 5, method="movingblock")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Politis, D. N., Romano, J. P., & Wolf, M. (1999). Subsampling. \emph{Springer N.Y.}.
}
\seealso{
\code{\link{best.block.sub.size}}, \code{\link{rate.block.sub}}.
}
\keyword{"Moving}
\keyword{"Subsampling"}
\keyword{block"}
