% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackVarRegen.atom.R
\name{jackVarRegen.atom}
\alias{jackVarRegen.atom}
\title{Jackknife Variance Estimator for Atomic Markov Chains}
\usage{
jackVarRegen.atom(x, func, atom, ...)
}
\arguments{
\item{x}{A vector or a matrix representing the Markov chain.}

\item{func}{The function to apply to each sample.}

\item{atom}{A numeric value or a string; an atom of the Markov chain in the atomic case.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns a scalar or a covariance matrix, depending on whether the function \code{func}
is univariate or multivariate. For a function returning a vector of length
\emph{p}, the output will be a covariance matrix of size \emph{p x p}.
}
\description{
Provides a regenerative jackknife estimator of the variance
of a function applied to atomic Markov chains.
}
\details{
This function uses a regenerative approach to estimate the
jackknife variance of a statistic for atomic Markov chains.
It segments the chain at the specified \code{atom} into independent
blocks. The function \code{func}, having output size equal to \emph{p},
is applied to the data with each regenerative block removed in turn to finally compute an empirical
variance of the obtained values. This approach is particularly useful
for atomic Markov chains.
}
\examples{
 B=1000
 set.seed(5)
 bb=0*(1:B)
 cc=0*(1:B)
 for (i in 1:B) {
   ts=genMM1(100,2,4)
   vv=function(ts){as.numeric(var(ts))}
   bb[i]=mean(ts)
   cc[i]=jackVarRegen.atom(ts,mean,atom=0)}
 var(bb)  # true variance of the mean (evaluated by Monte-Carlo)
 mean(cc) # mean of the variance estimators over the Monte-Carlo simulations
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.

Quenouille, M. H. (1956). Notes on bias in estimation. \emph{Biometrika}, \bold{43},
353–360.
}
\seealso{
\code{\link{jackVar}},
\code{\link{jackFunc}},
\code{\link{regenboot}},
\code{\link{jackFuncRegen}},
\code{\link{jackFuncBlock}},
\code{\link{jackVarRegen}}.
}
\keyword{"Atomic}
\keyword{"Regenerative}
\keyword{"Variance}
\keyword{Jackknife}
\keyword{Markov}
\keyword{chains"}
\keyword{estimation"}
\keyword{processes"}
