% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARSAdapted.R
\name{MARSAdapted_object}
\alias{MARSAdapted_object}
\title{Create an MARSAdapted object}
\usage{
MARSAdapted_object(
  data,
  x,
  y,
  rownames,
  nterms,
  Kp,
  d,
  err_red,
  minspan,
  endspan,
  na.rm,
  MARS.Forward,
  MARS.Forward.Smooth
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the variables in
the model.}

\item{x}{Column input indexes in \code{data}.}

\item{y}{Column output indexes in \code{data}.}

\item{rownames}{\code{string}. Data rownames.}

\item{nterms}{Maximum number of terms created by the forward algorithm .}

\item{Kp}{Maximum degree of interaction allowed. Default is \code{1}.}

\item{d}{Generalized Cross Validation (GCV) penalty per knot. Default is
\code{2}. If set to \code{-1}, \code{GCV = RSS / n}.}

\item{err_red}{Minimum reduced error rate for the addition of two new basis
functions. Default is \code{0.01}.}

\item{minspan}{Minimum number of observations between knots. When
\code{minspan = 0} (default), it is calculated as in Friedman's MARS paper
section 3.8 with alpha = 0.05.}

\item{endspan}{Minimum number of observations before the first and after the
final knot. When \code{endspan = 0} (default), it is calculated as in
Friedman's MARS paper section 3.8 with alpha = 0.05.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.}

\item{MARS.Forward}{The Multivariate Adaptive Frontier Splines model after
applying the forward algorithm without the smoothing procedures}

\item{MARS.Forward.Smooth}{The Multivariate Adaptive Frontier Splines model
after applying the forward algorithm after applying the smoothing procedure}
}
\value{
A \code{MARSAdapted} object.
}
\description{
This function saves information about the adapted Multivariate
Adaptive Frontier Splines model.
}
