% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{efficiency}
\alias{efficiency}
\title{Calculate efficiency scores}
\usage{
efficiency(
  model,
  measure = "rad.out",
  data,
  x,
  y,
  heuristic = TRUE,
  direction.vector = NULL,
  weights = NULL
)
}
\arguments{
\item{model}{Model object for which efficiency score is computed. Valid classes
are: \code{DEA}, \code{FDH}, \code{EATBoost} and \code{MARSBoost}.}

\item{measure}{Efficiency measure used. Valid measures are: \code{rad.out},
\code{rad.in}}

\item{data}{\code{data.frame} or \code{matrix} containing the new variables
in the model.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{heuristic}{Only used if \code{model} is \code{EATBoost}. This indicates
whether the heuristic or the exact approach is used.}

\item{direction.vector}{Only used when \code{measure} is \code{DDF}.Direction vector.
Valid values are: \code{dmu} (x_0, y_0), \code{unit} (unit vector),
\code{mean} (mean values of each variable) and a user specific vector of
the same length as the number of input and output variables}

\item{weights}{Only used when \code{measure} is \code{WAM}. Weights.
Valid values are: \code{MIP} (Measure of Inefficiency
Proportions), \code{RAM} (Range Adjusted Measure), \code{BAM} (Bounded
Adjusted Measure), \code{normalized} (normalized weighted additive model)
and a user specific vector of the same length as the number of input and
output variables}
}
\value{
\code{matrix} with the the predicted score
}
\description{
Calculates the efficiency score corresponding to the given model
using the given measure
}
