% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_cumulative_distribution_function.R
\name{empirical_cumulative_distribution_function}
\alias{empirical_cumulative_distribution_function}
\title{Empirical Cumulative Distribution Function (ECDF)}
\usage{
empirical_cumulative_distribution_function(data, sorted = FALSE)
}
\arguments{
\item{data}{A numeric vector of data points.}

\item{sorted}{A logical indicating whether the data is already sorted. Default is FALSE.}
}
\value{
An object representing the ECDF, with member function \verb{$ecdf(x)} to evaluate the ECDF at point(s) \code{x}.
}
\description{
Create an empirical cumulative distribution function (ECDF) from a given vector.
}
\examples{
data <- c(1.2, 2.3, 3.1, 4.5, 5.0)
ecdf_obj <- empirical_cumulative_distribution_function(data)
ecdf_obj$ecdf(3.0)  # Evaluate ECDF at x = 3.0
}
