% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_central_chi_squared_distribution.R
\name{non_central_chi_squared_distribution}
\alias{non_central_chi_squared_distribution}
\alias{non_central_chi_squared_pdf}
\alias{non_central_chi_squared_lpdf}
\alias{non_central_chi_squared_cdf}
\alias{non_central_chi_squared_lcdf}
\alias{non_central_chi_squared_quantile}
\alias{non_central_chi_squared_find_degrees_of_freedom}
\alias{non_central_chi_squared_find_non_centrality}
\title{Noncentral Chi-Squared Distribution Functions}
\usage{
non_central_chi_squared_distribution(df, lambda)

non_central_chi_squared_pdf(x, df, lambda)

non_central_chi_squared_lpdf(x, df, lambda)

non_central_chi_squared_cdf(x, df, lambda)

non_central_chi_squared_lcdf(x, df, lambda)

non_central_chi_squared_quantile(p, df, lambda)

non_central_chi_squared_find_degrees_of_freedom(lambda, x, alpha)

non_central_chi_squared_find_non_centrality(df, x, alpha)
}
\arguments{
\item{df}{degrees of freedom (df > 0)}

\item{lambda}{noncentrality parameter (lambda >= 0)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}

\item{alpha}{The acceptable probability of a Type I error (false positive).}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Noncentral Chi-Squared distribution.
}
\examples{
\dontrun{
# Noncentral Chi-Squared distribution with 3 degrees of freedom and noncentrality
# parameter 1
dist <- non_central_chi_squared_distribution(3, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
non_central_chi_squared_pdf(2, 3, 1)
non_central_chi_squared_lpdf(2, 3, 1)
non_central_chi_squared_cdf(2, 3, 1)
non_central_chi_squared_lcdf(2, 3, 1)
non_central_chi_squared_quantile(0.5, 3, 1)

# Find degrees of freedom needed for CDF at 2.0 with noncentrality parameter 1.0 = 0.05
non_central_chi_squared_find_degrees_of_freedom(1.0, 2.0, 0.05)
# Find noncentrality parameter needed for CDF at 2.0 with 3 degrees of freedom = 0.05
non_central_chi_squared_find_non_centrality(3, 2.0, 0.05)
}
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/nc_chi_squared_dist.html}{Boost Documentation} for more details on the mathematical background.
}
