% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boostrq.R
\name{boostrq}
\alias{boostrq}
\title{Fitting a boosting regression quantiles model}
\usage{
boostrq(
  formula,
  data,
  mstop = 100,
  nu = NULL,
  tau = 0.5,
  offset = NULL,
  weights = NULL,
  oobweights = NULL,
  risk = "inbag",
  digits = 10,
  exact.fit = FALSE
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{data}{a data frame (or data.table) containing the variables stated in the formula.}

\item{mstop}{number of iterations, as integer}

\item{nu}{learning rate, as numeric}

\item{tau}{quantile parameter, as numeric}

\item{offset}{a numeric vector used as offset.}

\item{weights}{(optional) a numeric vector indicating which weights to used in the fitting process
(default: all observations are equally weighted, with 1).}

\item{oobweights}{an additional vector of out-of-bag weights, which is used for the out-of-bag risk.}

\item{risk}{string indicating how the empirical risk should be computed for each boosting iteration.
inbag leads to risks computed for the learning sample (i.e. observations with non-zero weights),
oobag to risks based on the out-of-bag (i.e. observations with non-zero oobagweights).}

\item{digits}{number of digits the slope parameter different from zero to be
considered the best-fitting component, as integer.}

\item{exact.fit}{logical, if set to TRUE the negative gradients of exact fits are set to 0.}
}
\value{
A (generalized) additive quantile regression model is fitted using
the boosting regression quantiles algorithm, which is a functional component-wise
boosting algorithm.
The base-learner can be specified via the formula object. brq (linear quantile regression)
and brqss(nonlinear quantile regression) are available base-learner.
}
\description{
Component-wise functional gradient boosting algorithm to fit a quantile
regression model.
}
\examples{
boosted.rq <-
boostrq(
 formula = mpg ~ brq(cyl * hp) + brq(am + wt),
 data = mtcars,
 mstop = 200,
 nu = 0.1,
 tau = 0.5
)

boosted.rq$mstop()

boosted.rq$selection.freqs()

boosted.rq$coef()

boosted.rq$risk()

}
