% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms.R
\name{kms_encrypt}
\alias{kms_encrypt}
\title{Encrypt plain text via KMS}
\usage{
kms_encrypt(key, text, simplify = TRUE)
}
\arguments{
\item{key}{the KMS customer master key identifier as a fully
specified Amazon Resource Name (eg
\code{arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012})
or an alias with the \code{alias/} prefix (eg
\code{alias/foobar})}

\item{text}{max 4096 bytes long string, eg an RSA key, a database
password, or other sensitive customer information}

\item{simplify}{returns Base64-encoded text instead of raw list}
}
\value{
string or \code{list}
}
\description{
Encrypt plain text via KMS
}
\seealso{
\code{\link{kms_decrypt}}
}
