% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGMMmain.R
\name{pgmmRJMCMC}
\alias{pgmmRJMCMC}
\title{bpgmm Model-Based Clustering Using Baysian PGMM Carries out model-based clustering using parsimonious Gaussian mixture models. MCMC are used for parameter estimation. The RJMCMC is used for model selection.}
\usage{
pgmmRJMCMC(
  X,
  mInit,
  mVec,
  qnew,
  delta = 2,
  ggamma = 2,
  burn = 20,
  niter = 1000,
  constraint = C(0, 0, 0),
  dVec = c(1, 1, 1),
  sVec = c(1, 1, 1),
  Mstep = 0,
  Vstep = 0,
  SCind = 0
)
}
\arguments{
\item{X}{the observation matrix with size p * m}

\item{mInit}{the number of initial clusters}

\item{mVec}{the range of the number of clusters}

\item{qnew}{the number of factor for a new cluster}

\item{delta}{scaler hyperparameters}

\item{ggamma}{scaler hyperparameters}

\item{burn}{the number of burn in iterations}

\item{niter}{the number of iterations}

\item{constraint}{the pgmm initial constraint, a vector of length three with binary entry. For example, c(1,1,1) means the fully constraint model}

\item{dVec}{a vector of hyperparameters with length three, shape parameters for alpha1, alpha2 and bbeta respectively}

\item{sVec}{sVec a vector of hyperparameters with length three, rate parameters for alpha1, alpha2 and bbeta respectively}

\item{Mstep}{the indicator of whether do model selection on the number of clusters}

\item{Vstep}{the indicator of whether do model selection on variance structures}

\item{SCind}{the indicator of whether use split/combine step in Mstep}
}
\description{
bpgmm Model-Based Clustering Using Baysian PGMM Carries out model-based clustering using parsimonious Gaussian mixture models. MCMC are used for parameter estimation. The RJMCMC is used for model selection.
}
