% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brand.R
\name{get_brand_color_tint}
\alias{get_brand_color_tint}
\title{Get tints of brand colors}
\usage{
get_brand_color_tint(position = 500, color = "primary")
}
\arguments{
\item{position}{(Optional) A \code{\link[base:numeric]{numeric}} vector indicating
the position of the brand color in the range of tints. The range of
positions is from \code{0} to \code{1000} (Default: \code{500}).}

\item{color}{(Optional) A \code{\link[base:character]{character}} string indicating
the name of a color present in the \code{color} section of the \verb{_brand.yml}
file (Default: \code{"primary"}).}
}
\value{
A \code{\link[base:character]{character}} vector with
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal} color codes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{get_brand_color_tint()} generates a range of tints (color variations) for a
specific brand color, from black (position 0) through the brand color
(position 500) to white (position 1000).
}
\details{
\subsection{Path to \verb{_brand.yml}}{

\code{brandr} will always look for a \verb{_brand.yml} file in the root directory of
your project. If the file is not found, an error message will be displayed.
You can also set the path to the file manually using the
\code{\link[base:options]{options()}} function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(BRANDR_BRAND_YML = "PATH_TO_BRAND.YML")
}\if{html}{\out{</div>}}
}
}
\examples{
seq(0, 1000, 250)
#> [1]    0  250  500  750 1000 # Expected

get_brand_color_tint(seq(0, 1000, 250), color = "primary")
#> [1] "#000000" "#6D271E" "#DA4E3C" "#ECA69D" "#FFFFFF" # Expected
}
\seealso{
Other utility functions: 
\code{\link{get_brand_color}()},
\code{\link{get_brand_color_mix}()},
\code{\link{get_brand_font}()}
}
\concept{utility functions}
