% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_colors.R
\name{interpolate_colors}
\alias{interpolate_colors}
\title{Interpolate colors}
\usage{
interpolate_colors(
  n,
  colors = getOption("BRANDR_COLOR_SEQUENTIAL"),
  type = "seq",
  alpha = NULL,
  direction = 1,
  ...
)
}
\arguments{
\item{n}{This parameter accepts two types of inputs:
\itemize{
\item If the value is an integer number and \code{type} is \code{"seq"} or \code{"div"}, the
function will return a discrete color spectrum with \code{n} colors
\item If the value is an integer number and \code{type} is \code{"qual"}, the function
will return \code{n} colors from the \code{colors} parameter, repeating them if
necessary
\item If the value is a \code{\link[base:numeric]{numeric}} vector between \code{0} and \code{1},
the function will return the color positions at \code{n} considering a
continuous color spectrum ranging from \code{0} to \code{1}
}}

\item{colors}{(Optional) A \code{\link[base:character]{character}} vector of colors
to use in the scale. If \code{NULL}, \code{brandr} will choose the colors based
on the \code{type} argument.}

\item{type}{(Optional) A \code{\link[base:character]{character}} string indicating
the type of color scale: \code{"seq"}/\code{"sequential"},
\code{"div"}/\code{"diverging"}, or \code{"qual"}/\code{"qualitative"} (Default: \code{seq}).}

\item{alpha}{(Optional) A number between \code{0} and \code{1}, indicating the
transparency of the colors (Default: \code{NULL}).}

\item{direction}{(Optional) A number (\code{1} or \code{-1}) indicating the direction
of the colors. If \code{1}, the order remains the same. If \code{-1}, the order is
reversed. (Default: \code{1}).}

\item{...}{Additional arguments passed to
\code{\link[grDevices:colorRamp]{colorRampPalette()}} when creating the
color ramp. Only valid when type is \code{"seq"} or \code{"div"}.}
}
\value{
A \code{\link[base:character]{character}} vector with
\href{https://en.wikipedia.org/wiki/Web_colors}{hexadecimal} color codes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{interpolate_colors()} interpolate colors for sequential, diverging,
and qualitative color scales.
}
\examples{
interpolate_colors(3, colors = c("red", "blue"), type = "seq")
#> [1] "#FF0000" "#7F007F" "#0000FF" # Expected

interpolate_colors(3, colors = c("red", "blue"), direction = -1)
#> [1] "#0000FF" "#7F007F" "#FF0000" # Expected

interpolate_colors(3, colors = c("red", "blue"), alpha = 0.5)
#> [1] "#FF000080" "#7F007F80" "#0000FF80" # Expected

# `type = "seq"` and `type = "div"` produce the same result
interpolate_colors(3, colors = c("red", "white", "blue"), type = "div")
#> [1] "#FF0000" "#FFFFFF" "#0000FF" # Expected

interpolate_colors(3, colors = c("red", "blue"), type = "qual")
#> [1] "#FF0000" "#0000FF" "#FF0000" # Expected
}
\seealso{
Other color functions: 
\code{\link{color_brand_sequential}()}
}
\concept{color functions}
