% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculators.R
\name{calc_fv_annuity}
\alias{calc_fv_annuity}
\title{Future Value of an Annuity}
\usage{
calc_fv_annuity(pmt, rate, n, type = 0)
}
\arguments{
\item{pmt}{Payment amount per period.}

\item{rate}{Interest rate per period (decimal).}

\item{n}{Number of periods.}

\item{type}{Payment timing: 0 for end of period (ordinary annuity),
1 for beginning of period (annuity due).}
}
\value{
Future value of the annuity.
}
\description{
Calculates the future value of a series of equal payments.
}
\examples{
calc_fv_annuity(pmt = 100, rate = 0.05, n = 10, type = 0)
calc_fv_annuity(pmt = 100, rate = 0.05, n = 10, type = 1)

}
