% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internals.R
\name{robust_chol2inv}
\alias{robust_chol2inv}
\title{Robust inversion of symmetric matrices}
\usage{
robust_chol2inv(Sigma, eps = 1e-08, fallback_diag = TRUE)
}
\arguments{
\item{Sigma}{A symmetric matrix to invert.}

\item{eps}{Ridge value added to the diagonal to regularize the matrix.}

\item{fallback_diag}{Logical. If \code{TRUE}, return a diagonal matrix
as a fallback when Cholesky fails.}
}
\value{
A matrix of the same dimension as \code{Sigma}, representing its
regularized inverse.
}
\description{
Attempts to compute the inverse of a symmetric matrix using Cholesky
decomposition. If the matrix is not positive definite, a small ridge
value is added. If it still fails, a diagonal fallback is returned.
}
