% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{compute_historical_decompositions.PosteriorBSVARSIGN}
\alias{compute_historical_decompositions.PosteriorBSVARSIGN}
\title{Computes posterior draws of historical decompositions}
\usage{
\method{compute_historical_decompositions}{PosteriorBSVARSIGN}(posterior, show_progress = TRUE)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSIGN} obtained by running the \code{estimate} function.}

\item{show_progress}{a logical value, if \code{TRUE} the estimation progress bar is visible}
}
\value{
An object of class \code{PosteriorHD}, that is, an \code{NxNxTxS} array 
with attribute \code{PosteriorHD} containing \code{S} draws of the historical 
decompositions.
}
\description{
Each of the draws from the posterior estimation of models from
packages \pkg{bsvars} or \pkg{bsvarSIGNs} is transformed into
a draw from the posterior distribution of the historical decompositions. 
IMPORTANT! The historical decompositions are interpreted correctly for 
covariance stationary data. Application to unit-root non-stationary data might
result in non-interpretable outcomes.
}
\examples{
# upload data
data(optimism)

# specify the model and set seed
set.seed(123)

# + no effect on productivity (zero restriction)
# + positive effect on stock prices (positive sign restriction) 
sign_irf       = matrix(c(0, 1, rep(NA, 23)), 5, 5)
specification  = specify_bsvarSIGN$new(optimism, sign_irf = sign_irf)

# estimate the model
posterior      = estimate(specification, 10)

# compute historical decompositions
hd            = compute_historical_decompositions(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |> 
  estimate(S = 10) |> 
  compute_historical_decompositions() -> hd
  
}
\references{
Kilian, L., & Lütkepohl, H. (2017). Structural VAR Tools, Chapter 4, In: Structural vector autoregressive analysis. Cambridge University Press.
}
\seealso{
\code{\link{estimate.BSVARSIGN}}, \code{\link{summary}}, \code{\link{plot}}
}
\author{
Xiaolei Wang \email{adamwang15@gmail.com} and Tomasz Woźniak \email{wozniak.tom@pm.me}
}
