% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_plot_df.R
\name{.get_plot_df}
\alias{.get_plot_df}
\title{Returns Data Frame Ready for Plotting with Confidence Intervals}
\usage{
.get_plot_df(y_synth_draws, pre_data, post_data, time, outcome, ci = 0.75)
}
\arguments{
\item{y_synth_draws}{A data frame containing draws from the Stan fit object.}

\item{pre_data}{A data frame with data before the intervention.}

\item{post_data}{A data frame with data after the intervention.}

\item{time}{The name of the time period variable (as a string).}

\item{outcome}{The name of the outcome variable (as a string).}

\item{ci}{The width of the credible confidence interval (default: 0.75).}
}
\value{
A data frame containing:
\itemize{
\item \code{time}: The time period.
\item \code{outcome}: The observed outcome.
\item \code{y_synth}: The mean synthetic outcome.
\item \code{LB}: The lower bound of the confidence interval for the synthetic outcome.
\item \code{UB}: The upper bound of the confidence interval for the synthetic outcome.
\item \code{tau}: The difference between the observed and synthetic outcomes.
\item \code{tau_LB}: The lower bound of the confidence interval for \code{tau}.
\item \code{tau_UB}: The upper bound of the confidence interval for \code{tau}.
}
}
\description{
This function processes data frames containing synthetic and observed outcomes,
calculates confidence intervals for the synthetic outcomes, and returns a
combined data frame suitable for plotting the results.
}
