% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbergm.R
\name{createTbergm}
\alias{createTbergm}
\title{Constructor for \linkS4class{tbergm} objects}
\usage{
createTbergm(
  time.steps,
  formula,
  formula2,
  auto.adjust,
  offset,
  directed,
  bipartite,
  estimate,
  bergm,
  nvertices,
  data
)
}
\arguments{
\item{time.steps}{Object of class \code{"numeric"}. Number of time steps.}

\item{formula}{Object of class \code{"formula"}. The original model formula
(without indices for the time steps).}

\item{formula2}{The revised formula with the object references after applying
the \code{\link{tergmprepare}} function.}

\item{auto.adjust}{Object of class \code{"logical"}. Indicates whether
automatic adjustment of dimensions was done before estimation.}

\item{offset}{Object of class \code{"logical"}. Indicates whether an offset
matrix with structural zeros was used.}

\item{directed}{Object of class \code{"logical"}. Are the dependent networks
directed?}

\item{bipartite}{Object of class \code{"logical"}. Are the dependent networks
bipartite?}

\item{estimate}{Estimate: \code{"bergm"} for Bayesian estimation.}

\item{bergm}{The original \code{bergm} object as estimated by the
\code{\link[Bergm]{bergm}} function in the \pkg{Bergm} package.}

\item{nvertices}{Number of vertices.}

\item{data}{The data after processing by the \code{\link{tergmprepare}}
function.}
}
\description{
Constructor for \linkS4class{tbergm} objects.
}
\details{
Create an S4 \linkS4class{tbergm} object using this constructor function.
}
\seealso{
Other tergm-classes: 
\code{\link{btergm-class}},
\code{\link{createBtergm}()},
\code{\link{createMtergm}()},
\code{\link{mtergm-class}},
\code{\link{tbergm-class}}
}
\author{
Philip Leifeld
}
\concept{tergm-classes}
